/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint.transform;

import java.util.Collections;
import org.snapscript.core.attribute.Attribute;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.transform.AttributeRule;
import org.snapscript.core.constraint.transform.ConstraintIndex;
import org.snapscript.core.constraint.transform.ConstraintRule;
import org.snapscript.core.constraint.transform.ConstraintSource;
import org.snapscript.core.constraint.transform.ConstraintTransform;
import org.snapscript.core.constraint.transform.EmptySource;
import org.snapscript.core.constraint.transform.PositionIndex;
import org.snapscript.core.scope.Scope;

public class LocalTransform
implements ConstraintTransform {
    private final ConstraintSource source = new EmptySource();
    private final ConstraintIndex index = new PositionIndex(this.source, Collections.EMPTY_MAP);
    private final Attribute attribute;

    public LocalTransform(Attribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public ConstraintRule apply(Constraint left) {
        LocalRule rule = new LocalRule(this.index, this.attribute, left);
        return new AttributeRule(rule, this.attribute);
    }

    private static class LocalRule
    extends ConstraintRule {
        private final ConstraintIndex index;
        private final Constraint left;

        public LocalRule(ConstraintIndex index, Attribute attribute, Constraint left) {
            this.index = index;
            this.left = left;
        }

        @Override
        public Constraint getResult(Scope scope, Constraint returns) {
            return this.index.update(scope, this.left, returns);
        }

        @Override
        public Constraint getSource() {
            return null;
        }
    }
}

