/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.constraint.transform;

import java.util.List;
import java.util.Map;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintMapper;
import org.snapscript.core.constraint.transform.ConstraintSource;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;

public class PositionMapper {
    private final Map<String, Integer> positions;
    private final ConstraintMapper mapper = new ConstraintMapper();
    private final ConstraintSource source;

    public PositionMapper(ConstraintSource source, Map<String, Integer> positions) {
        this.positions = positions;
        this.source = source;
    }

    public Constraint resolve(Scope scope, Constraint constraint, String name) {
        Integer position = this.positions.get(name);
        if (position != null) {
            List<Constraint> constraints = this.source.getConstraints(constraint);
            int count = constraints.size();
            if (position >= count) {
                throw new InternalStateException("No generic parameter at " + position + " for " + this.source);
            }
            Constraint result = constraints.get(position);
            if (result == null) {
                throw new InternalStateException("No generic parameter at " + position + " for " + this.source);
            }
            return this.mapper.map(scope, result);
        }
        return this.mapper.map(scope, name);
    }
}

