/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.PrimitivePromoter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.type.Type;

public class ArrayCastChecker {
    private final PrimitivePromoter promoter = new PrimitivePromoter();
    private final CastChecker checker;

    public ArrayCastChecker(CastChecker checker) {
        this.checker = checker;
    }

    public Score toArray(Type actual, Type constraint) throws Exception {
        if (constraint != null && actual != null) {
            Type constraintEntry = constraint.getEntry();
            Type actualEntry = actual.getEntry();
            if (constraintEntry != null && actualEntry != null) {
                return this.toArray(actualEntry, constraintEntry);
            }
            if (constraintEntry == null && actualEntry == null) {
                Class constraintType = constraint.getType();
                Class actualType = actual.getType();
                if (constraintType != null && actualType != null) {
                    return this.toArray(actualType, constraintType);
                }
                return this.checker.toType(actual, constraint);
            }
        }
        return Score.INVALID;
    }

    public Score toArray(Class actual, Class constraint) throws Exception {
        if (constraint != null && actual != null) {
            Class actualType;
            Class<?> constraintEntry = constraint.getComponentType();
            Class<?> actualEntry = actual.getComponentType();
            if (actualEntry != null && constraintEntry != null) {
                return this.toArray(actualEntry, constraintEntry);
            }
            Class constraintType = this.promoter.promote(constraint);
            if (constraintType.equals(actualType = this.promoter.promote(actual))) {
                return Score.EXACT;
            }
            if (constraintType.isAssignableFrom(actualType)) {
                return Score.SIMILAR;
            }
            if (!Number.class.isAssignableFrom(constraintType)) {
                return Score.INVALID;
            }
            if (Number.class.isAssignableFrom(actualType)) {
                return Score.SIMILAR;
            }
        }
        return Score.INVALID;
    }
}

