/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.Array;
import java.util.List;
import org.snapscript.core.convert.ArrayCastChecker;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.type.Type;

public class ArrayConverter
extends ConstraintConverter {
    private final ConstraintMatcher matcher;
    private final ArrayCastChecker checker;
    private final ProxyWrapper wrapper;
    private final Type type;

    public ArrayConverter(ConstraintMatcher matcher, CastChecker checker, ProxyWrapper wrapper, Type type) {
        this.checker = new ArrayCastChecker(checker);
        this.wrapper = wrapper;
        this.matcher = matcher;
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class require = this.type.getType();
            Class real = actual.getType();
            if (real != null && List.class.isAssignableFrom(real)) {
                return Score.POSSIBLE;
            }
            if (require != real) {
                return this.checker.toArray(actual, this.type);
            }
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object object) throws Exception {
        if (object != null) {
            Class require = this.type.getType();
            Class<?> actual = object.getClass();
            if (List.class.isInstance(object)) {
                return this.score((List)object, this.type);
            }
            if (actual.isArray()) {
                if (require != actual) {
                    Score score = this.checker.toArray(actual, require);
                    if (score.isInvalid()) {
                        return this.score(object, this.type);
                    }
                    return score;
                }
                return Score.EXACT;
            }
            return Score.INVALID;
        }
        return Score.EXACT;
    }

    private Score score(Object list, Type type) throws Exception {
        Type entry = type.getEntry();
        if (entry != null) {
            int length = Array.getLength(list);
            ConstraintConverter converter = this.matcher.match(entry);
            if (length > 0) {
                Score total = Score.TRANSIENT;
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(list, i);
                    Object object = this.wrapper.fromProxy(element);
                    Score score = converter.score(object);
                    if (score.isInvalid()) {
                        return Score.INVALID;
                    }
                    total = Score.average(score, total);
                }
                return total;
            }
            return Score.SIMILAR;
        }
        return Score.INVALID;
    }

    private Score score(List list, Type type) throws Exception {
        Type entry = type.getEntry();
        if (entry != null) {
            int length = list.size();
            ConstraintConverter converter = this.matcher.match(entry);
            if (length > 0) {
                Score total = Score.TRANSIENT;
                for (int i = 0; i < length; ++i) {
                    Object element = list.get(i);
                    Object object = this.wrapper.fromProxy(element);
                    Score score = converter.score(object);
                    if (score.isInvalid()) {
                        return Score.INVALID;
                    }
                    total = Score.average(score, total);
                }
                return total;
            }
            return Score.POSSIBLE;
        }
        return Score.INVALID;
    }

    @Override
    public Object assign(Object object) throws Exception {
        if (object != null) {
            Class require = this.type.getType();
            Class<?> actual = object.getClass();
            if (actual.isArray()) {
                Score score = this.checker.toArray(actual, require);
                if (!score.isExact()) {
                    return this.convert(object, this.type);
                }
                return object;
            }
            if (List.class.isInstance(object)) {
                return this.convert((List)object, this.type);
            }
            throw new InternalStateException("Array can not be assigned from " + actual);
        }
        return object;
    }

    @Override
    public Object convert(Object object) throws Exception {
        if (object != null) {
            Class require = this.type.getType();
            Class<?> actual = object.getClass();
            if (actual.isArray()) {
                if (require != actual) {
                    return this.convert(object, this.type);
                }
                return object;
            }
            if (List.class.isInstance(object)) {
                return this.convert((List)object, this.type);
            }
            throw new InternalStateException("Array can not be converted from " + actual);
        }
        return object;
    }

    private Object convert(Object list, Type type) throws Exception {
        Type entry = type.getEntry();
        if (entry != null) {
            int length = Array.getLength(list);
            Class require = type.getType();
            Class<?> component = require.getComponentType();
            ConstraintConverter converter = this.matcher.match(entry);
            Object array = Array.newInstance(component, length);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(list, i);
                Object object = this.wrapper.fromProxy(element);
                if (object != null) {
                    Score score = converter.score(object);
                    if (score.isInvalid()) {
                        throw new InternalStateException("Array element is not '" + require + "'");
                    }
                    element = converter.convert(object);
                }
                Array.set(array, i, element);
            }
            return array;
        }
        throw new InternalStateException("Array element is not a list");
    }

    private Object convert(List list, Type type) throws Exception {
        Type entry = type.getEntry();
        if (entry != null) {
            int length = list.size();
            Class require = type.getType();
            Class<?> component = require.getComponentType();
            ConstraintConverter converter = this.matcher.match(entry);
            Object array = Array.newInstance(component, length);
            for (int i = 0; i < length; ++i) {
                Object element = list.get(i);
                Object object = this.wrapper.fromProxy(element);
                if (object != null) {
                    Score score = converter.score(object);
                    if (score.isInvalid()) {
                        throw new InternalStateException("Array element is not '" + require + "'");
                    }
                    element = converter.convert(object);
                }
                Array.set(array, i, element);
            }
            return array;
        }
        throw new InternalStateException("Array element is not a list");
    }
}

