/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.BooleanMatcher;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.type.Type;

public class BooleanConverter
extends ConstraintConverter {
    private final BooleanMatcher matcher = new BooleanMatcher();
    private final Type type;

    public BooleanConverter(Type type) {
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class real = actual.getType();
            if (real != null) {
                if (real == Boolean.class) {
                    return Score.EXACT;
                }
                if (real == Boolean.TYPE) {
                    return Score.EXACT;
                }
                if (real == String.class) {
                    return Score.POSSIBLE;
                }
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Score score(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            String text;
            Class<?> actual = value.getClass();
            if (actual == Boolean.class) {
                return Score.EXACT;
            }
            if (actual == String.class && this.matcher.matchBoolean(text = String.valueOf(value))) {
                return Score.POSSIBLE;
            }
            return Score.INVALID;
        }
        if (require.isPrimitive()) {
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Object convert(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            Class<?> actual = value.getClass();
            if (actual == String.class) {
                return this.convert(require, (String)value);
            }
            if (actual == Boolean.class) {
                return value;
            }
            throw new InternalArgumentException("Conversion from " + actual + " to boolean is not possible");
        }
        if (require.isPrimitive()) {
            throw new InternalArgumentException("Invalid conversion from null to primitive boolean");
        }
        return null;
    }
}

