/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.snapscript.core.ModifierType;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.FunctionComparator;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ClosureFunctionFinder;
import org.snapscript.core.function.Function;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.type.TypeLoader;

public class CastChecker {
    private final FunctionComparator comparator;
    private final ClosureFunctionFinder finder;
    private final TypeExtractor extractor;

    public CastChecker(ConstraintMatcher matcher, TypeExtractor extractor, TypeLoader loader) {
        this.comparator = new FunctionComparator(matcher);
        this.finder = new ClosureFunctionFinder(this.comparator, extractor, loader);
        this.extractor = extractor;
    }

    public Score toType(Type actual, Type constraint) throws Exception {
        if (!actual.equals(constraint)) {
            Set<Type> list = this.extractor.getTypes(actual);
            if (list.isEmpty()) {
                return Score.INVALID;
            }
            if (list.contains(constraint)) {
                return Score.SIMILAR;
            }
            int modifiers = actual.getModifiers();
            if (ModifierType.isFunction(modifiers)) {
                return this.toFunction(constraint, actual);
            }
            return Score.INVALID;
        }
        return Score.EXACT;
    }

    public Score toType(Type actual, Type constraint, Object value) throws Exception {
        if (!actual.equals(constraint)) {
            Set<Type> list = this.extractor.getTypes(actual);
            if (list.isEmpty()) {
                return Score.INVALID;
            }
            if (list.contains(constraint)) {
                return Score.SIMILAR;
            }
            int modifiers = actual.getModifiers();
            if (ModifierType.isFunction(modifiers)) {
                return this.toFunction(constraint, actual);
            }
            return Score.INVALID;
        }
        return Score.EXACT;
    }

    public Score toFunction(Type actual, Type constraint) throws Exception {
        int modifiers = constraint.getModifiers();
        if (ModifierType.isFunction(modifiers)) {
            Function possible = this.finder.findFunctional(actual);
            List<Function> functions = constraint.getFunctions();
            Iterator<Function> iterator = functions.iterator();
            Scope scope = actual.getScope();
            if (iterator.hasNext()) {
                Function required = iterator.next();
                if (possible != null) {
                    return this.comparator.compare(scope, possible, required);
                }
            }
        }
        return Score.INVALID;
    }

    public Score toFunction(Type actual, Type constraint, Object value) throws Exception {
        Type type = this.extractor.getType(value);
        int modifiers = type.getModifiers();
        if (ModifierType.isFunction(modifiers)) {
            Function possible = this.finder.findFunctional(type);
            List<Function> functions = constraint.getFunctions();
            Iterator<Function> iterator = functions.iterator();
            Scope scope = actual.getScope();
            if (iterator.hasNext()) {
                Function required = iterator.next();
                if (possible != null) {
                    return this.comparator.compare(scope, possible, required);
                }
            }
        }
        return Score.INVALID;
    }
}

