/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.type.Type;

public class ClassConverter
extends ConstraintConverter {
    private final Type type;

    public ClassConverter(Type type) {
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class real = actual.getType();
            if (real == Class.class) {
                return Score.EXACT;
            }
            if (Type.class.isAssignableFrom(real)) {
                return Score.EXACT;
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Score score(Object value) throws Exception {
        if (value != null) {
            Class<?> real = value.getClass();
            if (real == Class.class) {
                return Score.EXACT;
            }
            if (Type.class.isAssignableFrom(real)) {
                return Score.EXACT;
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Object convert(Object value) throws Exception {
        if (value != null) {
            Class<?> real = value.getClass();
            if (real == Class.class) {
                return value;
            }
            if (Type.class.isInstance(value)) {
                Type type = (Type)value;
                return type.getType();
            }
            throw new InternalArgumentException("Conversion from " + this.type + " to class is not possible");
        }
        return null;
    }
}

