/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.convert.ConstraintAdapter;
import org.snapscript.core.convert.PrimitivePromoter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.type.Type;

public abstract class ConstraintConverter {
    protected final PrimitivePromoter promoter = new PrimitivePromoter();
    protected final ConstraintAdapter adapter = new ConstraintAdapter();

    protected ConstraintConverter() {
    }

    protected Object convert(Class type, String text) throws Exception {
        Class actual = this.promoter.promote(type);
        try {
            if (actual == String.class) {
                return text;
            }
            if (actual == Integer.class) {
                return this.adapter.createInteger(text);
            }
            if (actual == Double.class) {
                return this.adapter.createDouble(text);
            }
            if (actual == Float.class) {
                return this.adapter.createFloat(text);
            }
            if (actual == Boolean.class) {
                return this.adapter.createBoolean(text);
            }
            if (actual == Byte.class) {
                return this.adapter.createByte(text);
            }
            if (actual == Short.class) {
                return this.adapter.createShort(text);
            }
            if (actual == Long.class) {
                return this.adapter.createLong(text);
            }
            if (actual == AtomicLong.class) {
                return this.adapter.createAtomicLong(text);
            }
            if (actual == AtomicInteger.class) {
                return this.adapter.createAtomicInteger(text);
            }
            if (actual == BigDecimal.class) {
                return this.adapter.createBigDecimal(text);
            }
            if (actual == BigInteger.class) {
                return this.adapter.createBigInteger(text);
            }
            if (actual == Character.class) {
                return this.adapter.createCharacter(text);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Could not convert '" + text + "' to " + actual, e);
        }
        throw new InternalArgumentException("Could not convert '" + text + "' to " + actual);
    }

    protected Object convert(Class type, Number number) {
        Class actual = this.promoter.promote(type);
        Class<?> real = number.getClass();
        try {
            if (actual == real) {
                return number;
            }
            if (actual == Number.class) {
                return number;
            }
            if (actual == Double.class) {
                return this.adapter.createDouble(number);
            }
            if (actual == Float.class) {
                return this.adapter.createFloat(number);
            }
            if (actual == Integer.class) {
                return this.adapter.createInteger(number);
            }
            if (actual == Long.class) {
                return this.adapter.createLong(number);
            }
            if (actual == Byte.class) {
                return this.adapter.createByte(number);
            }
            if (actual == Short.class) {
                return this.adapter.createShort(number);
            }
            if (actual == AtomicLong.class) {
                return this.adapter.createAtomicLong(number);
            }
            if (actual == AtomicInteger.class) {
                return this.adapter.createAtomicInteger(number);
            }
            if (actual == BigDecimal.class) {
                return this.adapter.createBigDecimal(number);
            }
            if (actual == BigInteger.class) {
                return this.adapter.createBigInteger(number);
            }
            if (actual == Character.class) {
                return this.adapter.createCharacter(number);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Could not convert '" + number + "' to " + type);
        }
        throw new InternalArgumentException("Could not convert '" + number + "' to " + actual);
    }

    public Object assign(Object value) throws Exception {
        return this.convert(value);
    }

    public abstract Object convert(Object var1) throws Exception;

    public abstract Score score(Type var1) throws Exception;

    public abstract Score score(Object var1) throws Exception;
}

