/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.EntityCache;
import org.snapscript.core.convert.AliasResolver;
import org.snapscript.core.convert.AnyConverter;
import org.snapscript.core.convert.ArrayConverter;
import org.snapscript.core.convert.AtomicIntegerConverter;
import org.snapscript.core.convert.AtomicLongConverter;
import org.snapscript.core.convert.BigDecimalConverter;
import org.snapscript.core.convert.BigIntegerConverter;
import org.snapscript.core.convert.BooleanConverter;
import org.snapscript.core.convert.ByteConverter;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.CharacterConverter;
import org.snapscript.core.convert.ClassConverter;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintInspector;
import org.snapscript.core.convert.DoubleConverter;
import org.snapscript.core.convert.EnumConverter;
import org.snapscript.core.convert.FloatConverter;
import org.snapscript.core.convert.FunctionConverter;
import org.snapscript.core.convert.IntegerConverter;
import org.snapscript.core.convert.ListConverter;
import org.snapscript.core.convert.LongConverter;
import org.snapscript.core.convert.NullConverter;
import org.snapscript.core.convert.NumberConverter;
import org.snapscript.core.convert.ObjectConverter;
import org.snapscript.core.convert.PropertiesConverter;
import org.snapscript.core.convert.ScopeConverter;
import org.snapscript.core.convert.ShortConverter;
import org.snapscript.core.convert.StringConverter;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.type.TypeLoader;

public class ConstraintMatcher {
    private final EntityCache<ConstraintConverter> converters = new EntityCache();
    private final ConstraintInspector inspector;
    private final ConstraintConverter converter;
    private final TypeExtractor extractor;
    private final AliasResolver resolver;
    private final CastChecker checker;
    private final ProxyWrapper wrapper;

    public ConstraintMatcher(TypeLoader loader, ProxyWrapper wrapper) {
        this.extractor = new TypeExtractor(loader);
        this.checker = new CastChecker(this, this.extractor, loader);
        this.inspector = new ConstraintInspector(loader, this.checker);
        this.converter = new NullConverter();
        this.resolver = new AliasResolver();
        this.wrapper = wrapper;
    }

    public ConstraintConverter match(Type type) throws Exception {
        if (type != null) {
            ConstraintConverter converter = this.converters.fetch(type);
            if (converter == null) {
                converter = this.resolve(type);
                this.converters.cache(type, converter);
            }
            return converter;
        }
        return this.converter;
    }

    private ConstraintConverter resolve(Type declare) throws Exception {
        Type type = this.resolver.resolve(declare);
        if (this.inspector.isSame(type, Object.class)) {
            return new AnyConverter(this.wrapper);
        }
        if (this.inspector.isSame(type, Double.TYPE)) {
            return new DoubleConverter(type);
        }
        if (this.inspector.isSame(type, Float.TYPE)) {
            return new FloatConverter(type);
        }
        if (this.inspector.isSame(type, Integer.TYPE)) {
            return new IntegerConverter(type);
        }
        if (this.inspector.isSame(type, Long.TYPE)) {
            return new LongConverter(type);
        }
        if (this.inspector.isSame(type, Short.TYPE)) {
            return new ShortConverter(type);
        }
        if (this.inspector.isSame(type, Byte.TYPE)) {
            return new ByteConverter(type);
        }
        if (this.inspector.isSame(type, Character.TYPE)) {
            return new CharacterConverter(type);
        }
        if (this.inspector.isSame(type, Boolean.TYPE)) {
            return new BooleanConverter(type);
        }
        if (this.inspector.isSame(type, Number.class)) {
            return new NumberConverter(type);
        }
        if (this.inspector.isSame(type, Double.class)) {
            return new DoubleConverter(type);
        }
        if (this.inspector.isSame(type, Float.class)) {
            return new FloatConverter(type);
        }
        if (this.inspector.isSame(type, Integer.class)) {
            return new IntegerConverter(type);
        }
        if (this.inspector.isSame(type, Long.class)) {
            return new LongConverter(type);
        }
        if (this.inspector.isSame(type, Short.class)) {
            return new ShortConverter(type);
        }
        if (this.inspector.isSame(type, Byte.class)) {
            return new ByteConverter(type);
        }
        if (this.inspector.isSame(type, Character.class)) {
            return new CharacterConverter(type);
        }
        if (this.inspector.isSame(type, Boolean.class)) {
            return new BooleanConverter(type);
        }
        if (this.inspector.isSame(type, BigDecimal.class)) {
            return new BigDecimalConverter(type);
        }
        if (this.inspector.isSame(type, BigInteger.class)) {
            return new BigIntegerConverter(type);
        }
        if (this.inspector.isSame(type, AtomicLong.class)) {
            return new AtomicLongConverter(type);
        }
        if (this.inspector.isSame(type, AtomicInteger.class)) {
            return new AtomicIntegerConverter(type);
        }
        if (this.inspector.isSame(type, String.class)) {
            return new StringConverter();
        }
        if (this.inspector.isFunction(type)) {
            return new FunctionConverter(this.extractor, this.checker, this.wrapper, type);
        }
        if (this.inspector.isLike(type, Scope.class)) {
            return new ScopeConverter();
        }
        if (this.inspector.isLike(type, Enum.class)) {
            return new EnumConverter(type);
        }
        if (this.inspector.isSame(type, Class.class)) {
            return new ClassConverter(type);
        }
        if (this.inspector.isSame(type, List.class)) {
            return new ListConverter(this.extractor, this.checker, this.wrapper, type);
        }
        if (this.inspector.isSame(type, Properties.class)) {
            return new PropertiesConverter(this.extractor, this.checker, this.wrapper, type);
        }
        if (this.inspector.isArray(type)) {
            return new ArrayConverter(this, this.checker, this.wrapper, type);
        }
        return new ObjectConverter(this.extractor, this.checker, this.wrapper, type);
    }
}

