/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.type.Type;

public class EnumConverter
extends ConstraintConverter {
    private final Type type;

    public EnumConverter(Type type) {
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class require;
            Class real = actual.getType();
            if (real != (require = this.type.getType())) {
                if (require.isAssignableFrom(real)) {
                    return Score.EXACT;
                }
                if (real == String.class) {
                    return Score.SIMILAR;
                }
                return Score.INVALID;
            }
            return Score.EXACT;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Score score(Object value) throws Exception {
        if (value != null) {
            Class<?> real = value.getClass();
            Class require = this.type.getType();
            if (require.isAssignableFrom(real)) {
                return Score.EXACT;
            }
            if (real == String.class) {
                return Score.SIMILAR;
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Object convert(Object value) throws Exception {
        if (value != null) {
            Class require = this.type.getType();
            if (require.isInstance(value)) {
                return value;
            }
            String text = String.valueOf(value);
            return Enum.valueOf(require, text);
        }
        return null;
    }
}

