/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.type.Type;

public class FixedArgumentConverter
implements ArgumentConverter {
    private final ConstraintConverter[] converters;

    public FixedArgumentConverter(ConstraintConverter[] converters) {
        this.converters = converters;
    }

    @Override
    public Score score(Type ... list) throws Exception {
        if (list.length != this.converters.length) {
            return Score.INVALID;
        }
        if (list.length > 0) {
            Score total = Score.INVALID;
            for (int i = 0; i < list.length; ++i) {
                ConstraintConverter converter = this.converters[i];
                Type type = list[i];
                Score score = converter.score(type);
                if (score.isInvalid()) {
                    return Score.INVALID;
                }
                total = Score.sum(total, score);
            }
            return total;
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object ... list) throws Exception {
        if (list.length != this.converters.length) {
            return Score.INVALID;
        }
        if (list.length > 0) {
            Score total = Score.INVALID;
            for (int i = 0; i < list.length; ++i) {
                ConstraintConverter converter = this.converters[i];
                Object value = list[i];
                Score score = converter.score(value);
                if (score.isInvalid()) {
                    return Score.INVALID;
                }
                total = Score.sum(total, score);
            }
            return total;
        }
        return Score.EXACT;
    }

    @Override
    public Object[] assign(Object ... list) throws Exception {
        if (list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                ConstraintConverter converter = this.converters[i];
                Object value = list[i];
                list[i] = converter.assign(value);
            }
            return list;
        }
        return list;
    }

    @Override
    public Object[] convert(Object ... list) throws Exception {
        if (list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                ConstraintConverter converter = this.converters[i];
                Object value = list[i];
                list[i] = converter.convert(value);
            }
            return list;
        }
        return list;
    }
}

