/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class FunctionComparator {
    private final ConstraintMatcher matcher;

    public FunctionComparator(ConstraintMatcher matcher) {
        this.matcher = matcher;
    }

    public Score compare(Scope scope, Function left, Function right) throws Exception {
        Signature leftSignature = left.getSignature();
        Signature rightSignature = right.getSignature();
        List<Parameter> leftParameters = leftSignature.getParameters();
        List<Parameter> rightParameters = rightSignature.getParameters();
        return this.compare(scope, leftParameters, rightParameters);
    }

    public Score compare(Scope scope, List<Parameter> left, List<Parameter> right) throws Exception {
        Score score;
        boolean rightVariable;
        Score score2;
        int rightSize;
        int leftSize = left.size();
        if (leftSize == (rightSize = right.size()) && (score2 = this.score(scope, left, right)).isValid()) {
            return score2;
        }
        boolean leftVariable = leftSize > 0 && left.get(leftSize - 1).isVariable();
        boolean bl = rightVariable = rightSize > 0 && right.get(rightSize - 1).isVariable();
        if (leftVariable && leftSize <= rightSize && (score = this.score(scope, left, right)).isValid()) {
            return score;
        }
        if (rightVariable && rightSize <= leftSize && (score = this.score(scope, right, left)).isValid()) {
            return score;
        }
        return Score.INVALID;
    }

    private Score score(Scope scope, List<Parameter> left, List<Parameter> right) throws Exception {
        int leftSize = left.size();
        if (leftSize > 0) {
            Score total = Score.INVALID;
            int j = 0;
            for (int i = 0; i < leftSize; ++i) {
                Parameter rightParameter;
                Parameter leftParameter = left.get(i);
                Score score = this.score(scope, leftParameter, rightParameter = right.get(j));
                if (score.isInvalid()) {
                    return Score.INVALID;
                }
                total = Score.sum(total, score);
                if (leftParameter.isVariable()) continue;
                ++j;
            }
            return total;
        }
        return Score.EXACT;
    }

    private Score score(Scope scope, Parameter left, Parameter right) throws Exception {
        Constraint leftConstraint = left.getConstraint();
        Constraint rightConstraint = right.getConstraint();
        Type leftType = leftConstraint.getType(scope);
        Type rightType = rightConstraint.getType(scope);
        ConstraintConverter converter = this.matcher.match(leftType);
        Score score = converter.score(rightType);
        if (left.isVariable()) {
            if (score.isInvalid()) {
                return Score.INVALID;
            }
            return Score.POSSIBLE;
        }
        return score;
    }
}

