/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.ModifierType;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class FunctionConverter
extends ConstraintConverter {
    private final CastChecker checker;
    private final TypeExtractor extractor;
    private final ProxyWrapper wrapper;
    private final Type constraint;

    public FunctionConverter(TypeExtractor extractor, CastChecker checker, ProxyWrapper wrapper, Type constraint) {
        this.constraint = constraint;
        this.extractor = extractor;
        this.wrapper = wrapper;
        this.checker = checker;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            return this.checker.toFunction(actual, this.constraint);
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object object) throws Exception {
        if (object != null) {
            Object real;
            Type match = this.extractor.getType(object);
            int modifiers = match.getModifiers();
            if (ModifierType.isProxy(modifiers) && (real = this.wrapper.fromProxy(object)) != object) {
                return this.score(real);
            }
            return this.checker.toFunction(match, this.constraint, object);
        }
        return Score.EXACT;
    }

    @Override
    public Object assign(Object object) throws Exception {
        if (object != null) {
            Object real;
            Type match = this.extractor.getType(object);
            int modifiers = match.getModifiers();
            if (ModifierType.isProxy(modifiers) && (real = this.wrapper.fromProxy(object)) != object) {
                return this.assign(real);
            }
            Score score = this.checker.toFunction(match, this.constraint, object);
            if (score.isInvalid()) {
                throw new InternalArgumentException("Conversion from " + match + " to '" + this.constraint + "' is not possible");
            }
        }
        return object;
    }

    @Override
    public Object convert(Object object) throws Exception {
        if (object != null) {
            Object real;
            Type match = this.extractor.getType(object);
            int modifiers = match.getModifiers();
            if (ModifierType.isProxy(modifiers) && (real = this.wrapper.fromProxy(object)) != object) {
                return this.assign(real);
            }
            Score score = this.checker.toFunction(match, this.constraint, object);
            if (score.isInvalid()) {
                throw new InternalArgumentException("Conversion from " + match + " to '" + this.constraint + "' is not possible");
            }
        }
        return object;
    }
}

