/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.snapscript.core.Any;
import org.snapscript.core.Context;
import org.snapscript.core.EntityCache;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class InterfaceCollector {
    private final EntityCache<Class[]> cache = new EntityCache();
    private final Class[] include;
    private final Class[] empty = new Class[0];

    public InterfaceCollector(Class ... include) {
        this.include = include;
    }

    public Class[] collect(Scope scope) {
        Type type = scope.getHandle();
        if (type != null) {
            return this.collect(type);
        }
        return this.empty;
    }

    public Class[] collect(Type type) {
        Class[] interfaces = this.cache.fetch(type);
        if (interfaces == null) {
            Set<Class> types = this.traverse(type);
            Class[] result = this.convert(types);
            this.cache.cache(type, result);
            return result;
        }
        return interfaces;
    }

    public Class[] collect(Class ... types) {
        if (types.length > 0) {
            HashSet<Class> interfaces = new HashSet<Class>();
            for (Class entry : types) {
                if (entry == null || !entry.isInterface()) continue;
                interfaces.add(entry);
            }
            return this.convert(interfaces);
        }
        return this.empty;
    }

    private Set<Class> traverse(Type type) {
        Module module = type.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Set<Type> types = extractor.getTypes(type);
        if (!types.isEmpty()) {
            HashSet<Class> interfaces = new HashSet<Class>();
            for (Type entry : types) {
                Class part = entry.getType();
                if (part == null) continue;
                int modifiers = part.getModifiers();
                if (!part.isInterface() || !Modifier.isPublic(modifiers)) continue;
                interfaces.add(part);
            }
            for (Class entry : this.include) {
                interfaces.add(entry);
            }
            interfaces.add(Any.class);
            return interfaces;
        }
        return Collections.singleton(Any.class);
    }

    private Class[] convert(Set<Class> types) {
        int size = types.size();
        if (size > 0) {
            Class[] array = new Class[size];
            int index = 0;
            for (Class type : types) {
                array[index++] = type;
            }
            return array;
        }
        return this.empty;
    }
}

