/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.array.ArrayBuilder;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ObjectConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class ListConverter
extends ConstraintConverter {
    private final ObjectConverter converter;
    private final ArrayBuilder builder;

    public ListConverter(TypeExtractor extractor, CastChecker checker, ProxyWrapper wrapper, Type constraint) {
        this.converter = new ObjectConverter(extractor, checker, wrapper, constraint);
        this.builder = new ArrayBuilder();
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Type entry = actual.getEntry();
            if (entry == null) {
                return this.converter.score(actual);
            }
            return Score.POSSIBLE;
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object object) throws Exception {
        if (object != null) {
            Class<?> type = object.getClass();
            if (!type.isArray()) {
                return this.converter.score(object);
            }
            return Score.POSSIBLE;
        }
        return Score.EXACT;
    }

    @Override
    public Object assign(Object object) throws Exception {
        if (object != null) {
            Class<?> type = object.getClass();
            if (!type.isArray()) {
                return this.converter.assign(object);
            }
            return this.builder.convert(object);
        }
        return object;
    }

    @Override
    public Object convert(Object object) throws Exception {
        if (object != null) {
            Class<?> type = object.getClass();
            if (!type.isArray()) {
                return this.converter.assign(object);
            }
            return this.builder.convert(object);
        }
        return object;
    }
}

