/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.ModifierType;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class ObjectConverter
extends ConstraintConverter {
    private final CastChecker checker;
    private final TypeExtractor extractor;
    private final ProxyWrapper wrapper;
    private final Type constraint;

    public ObjectConverter(TypeExtractor extractor, CastChecker checker, ProxyWrapper wrapper, Type constraint) {
        this.constraint = constraint;
        this.extractor = extractor;
        this.wrapper = wrapper;
        this.checker = checker;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null && actual != this.constraint) {
            return this.checker.toType(actual, this.constraint);
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object object) throws Exception {
        Type match;
        if (object != null && !(match = this.extractor.getType(object)).equals(this.constraint)) {
            return this.checker.toType(match, this.constraint, object);
        }
        return Score.EXACT;
    }

    @Override
    public Object assign(Object object) throws Exception {
        Type match;
        if (object != null && (match = this.extractor.getType(object)) != this.constraint) {
            Score score = this.checker.toType(match, this.constraint, object);
            int modifiers = match.getModifiers();
            if (score.isInvalid()) {
                Class require = this.constraint.getType();
                if (require == null) {
                    throw new InternalArgumentException("Conversion from " + match + " to '" + this.constraint + "' is not possible");
                }
                return this.convert(object);
            }
            if (ModifierType.isFunction(modifiers)) {
                return this.convert(object);
            }
        }
        return object;
    }

    @Override
    public Object convert(Object object) throws Exception {
        Class require;
        if (object != null && (require = this.constraint.getType()) != null) {
            return this.wrapper.toProxy(object, require);
        }
        return object;
    }
}

