/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.util.Map;
import java.util.Properties;
import org.snapscript.core.convert.CastChecker;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ObjectConverter;
import org.snapscript.core.convert.PropertiesBuilder;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class PropertiesConverter
extends ConstraintConverter {
    private final ObjectConverter converter;

    public PropertiesConverter(TypeExtractor extractor, CastChecker checker, ProxyWrapper wrapper, Type constraint) {
        this.converter = new ObjectConverter(extractor, checker, wrapper, constraint);
    }

    @Override
    public Score score(Type actual) throws Exception {
        Class type;
        if (actual != null && (type = actual.getType()) != Properties.class) {
            if (Map.class.isAssignableFrom(type)) {
                return Score.POSSIBLE;
            }
            return this.converter.score(actual);
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object object) throws Exception {
        Class<?> type;
        if (object != null && (type = object.getClass()) != Properties.class) {
            if (Map.class.isAssignableFrom(type)) {
                return Score.POSSIBLE;
            }
            return this.converter.score(object);
        }
        return Score.EXACT;
    }

    @Override
    public Object convert(Object object) throws Exception {
        Class<?> type;
        if (object != null && (type = object.getClass()) != Properties.class) {
            if (Map.class.isAssignableFrom(type)) {
                return PropertiesBuilder.create((Map)object);
            }
            return this.converter.convert(object);
        }
        return object;
    }
}

