/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

public class Score
implements Comparable<Score> {
    public static final Score EXACT = new Score(100.0, true);
    public static final Score SIMILAR = new Score(70.0, true);
    public static final Score COMPATIBLE = new Score(20.0, true);
    public static final Score TRANSIENT = new Score(20.0, false);
    public static final Score POSSIBLE = new Score(10.0, true);
    public static final Score INVALID = new Score(0.0, true);
    private final boolean cache;
    private final Double score;

    public static Score sum(Score left, Score right) {
        return new Score(left.score + right.score, left.cache && right.cache);
    }

    public static Score average(Score left, Score right) {
        return new Score((left.score + right.score) / 2.0, left.cache && right.cache);
    }

    public Score(double score) {
        this(score, true);
    }

    public Score(double score, boolean cache) {
        this.score = score;
        this.cache = cache;
    }

    public double getScore() {
        return this.score;
    }

    public boolean isAbsolute() {
        return this.cache;
    }

    public boolean isExact() {
        return this.score >= Score.EXACT.score;
    }

    public boolean isCompatible() {
        return this.score >= Score.COMPATIBLE.score;
    }

    public boolean isSimilar() {
        return this.score >= Score.SIMILAR.score;
    }

    public boolean isInvalid() {
        return this.score <= Score.INVALID.score;
    }

    public boolean isValid() {
        return this.score > Score.INVALID.score;
    }

    @Override
    public int compareTo(Score other) {
        return this.score.compareTo(other.score);
    }

    public String toString() {
        return this.score.toString();
    }
}

