/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.Proxy;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.AnyConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.Function;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class TypeInspector {
    private final Constraint any = new AnyConstraint();

    public boolean isAny(Type type) {
        String name = type.getName();
        if (name.equals("Any")) {
            Scope scope = type.getScope();
            Type base = this.any.getType(scope);
            return type == base;
        }
        return false;
    }

    public boolean isProxy(Type type) {
        Class real = type.getType();
        if (real != null) {
            return Proxy.class.isAssignableFrom(real);
        }
        return false;
    }

    public boolean isArray(Type type) throws Exception {
        int modifiers = type.getModifiers();
        return ModifierType.isArray(modifiers);
    }

    public boolean isFunction(Type type) throws Exception {
        int modifiers = type.getModifiers();
        return ModifierType.isFunction(modifiers);
    }

    public boolean isSame(Type type, Class require) throws Exception {
        Class actual = type.getType();
        return actual == require;
    }

    public boolean isConstructor(Type type, Function function) {
        Type source = function.getSource();
        String name = function.getName();
        if (name.equals("new")) {
            return source == type;
        }
        return false;
    }

    public boolean isSuperConstructor(Type type, Function function) {
        Type source = function.getSource();
        String name = function.getName();
        if (name.equals("new")) {
            return source != type;
        }
        return false;
    }

    public boolean isCompatible(Type type, Object value) throws Exception {
        if (type != null) {
            Module module = type.getModule();
            Context context = module.getContext();
            ConstraintMatcher matcher = context.getMatcher();
            ConstraintConverter converter = matcher.match(type);
            Score score = converter.score(value);
            return score.isValid();
        }
        return true;
    }
}

