/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert.proxy;

import java.lang.reflect.Method;
import org.snapscript.core.convert.proxy.ProxyArgumentExtractor;
import org.snapscript.core.convert.proxy.ProxyHandler;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Transient;
import org.snapscript.core.variable.Value;

public class FunctionProxyHandler
implements ProxyHandler {
    private final ProxyArgumentExtractor extractor;
    private final FunctionResolver resolver;
    private final ProxyWrapper wrapper;
    private final Function function;
    private final Value value;

    public FunctionProxyHandler(ProxyWrapper wrapper, FunctionResolver resolver, Function function) {
        this.extractor = new ProxyArgumentExtractor(wrapper);
        this.value = new Transient(function);
        this.resolver = resolver;
        this.function = function;
        this.wrapper = wrapper;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object[] convert = this.extractor.extract(arguments);
        String name = method.getName();
        int width = convert.length;
        if (name.equals("hashCode")) {
            if (width != 0) {
                throw new InternalStateException("Closure 'hashCode' does not accept " + width + " arguments");
            }
            return this.function.hashCode();
        }
        if (name.equals("toString")) {
            if (width != 0) {
                throw new InternalStateException("Closure 'toString' does not accept " + width + " arguments");
            }
            return this.function.toString();
        }
        if (name.equals("equals")) {
            if (width != 1) {
                throw new InternalStateException("Closure 'equals' does not accept " + width + " arguments");
            }
            return this.function.equals(convert[0]);
        }
        if (convert.length > 0) {
            return this.invoke(proxy, name, convert, arguments);
        }
        return this.invoke(proxy, name, convert, convert);
    }

    private Object invoke(Object proxy, String name, Object[] convert, Object[] arguments) throws Throwable {
        Connection call = this.resolve(proxy, name, convert, arguments);
        int width = arguments.length;
        if (call == null) {
            throw new InternalStateException("Closure not matched with " + width + " arguments");
        }
        Object data = call.invoke(null, proxy, arguments);
        if (data != null) {
            return this.wrapper.toProxy(data);
        }
        return null;
    }

    private Connection resolve(Object proxy, String name, Object[] convert, Object[] arguments) throws Throwable {
        Scope scope;
        FunctionCall call;
        Type source = this.function.getSource();
        if (source != null && (call = this.resolver.resolveInstance(scope = source.getScope(), proxy, name, arguments)) != null) {
            return new ProxyConnection(call, scope);
        }
        FunctionCall call2 = this.resolver.resolveValue(this.value, convert);
        if (call2 != null) {
            return new ProxyConnection(call2, null);
        }
        return null;
    }

    @Override
    public Function extract() {
        return this.function;
    }

    private static class ProxyConnection
    implements Connection {
        private final FunctionCall call;
        private final Scope outer;

        public ProxyConnection(FunctionCall call, Scope outer) {
            this.outer = outer;
            this.call = call;
        }

        @Override
        public boolean match(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.match(scope, object, arguments);
        }

        @Override
        public Object invoke(Scope scope, Object object, Object ... arguments) throws Exception {
            if (this.outer != null) {
                return this.call.invoke(this.outer, object, arguments);
            }
            return this.call.invoke(scope, scope, arguments);
        }
    }
}

