/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.snapscript.core.Any;
import org.snapscript.core.Context;
import org.snapscript.core.ContextClassLoader;
import org.snapscript.core.convert.InterfaceCollector;
import org.snapscript.core.convert.proxy.Delegate;
import org.snapscript.core.convert.proxy.FunctionProxyHandler;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.convert.proxy.ScopeProxyHandler;
import org.snapscript.core.convert.proxy.TraceProxyHandler;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.trace.TraceInterceptor;

public class ProxyFactory {
    private final InterfaceCollector collector;
    private final ProxyWrapper wrapper;
    private final ClassLoader loader = new ContextClassLoader(Any.class);
    private final Context context;

    public ProxyFactory(ProxyWrapper wrapper, Context context) {
        this.collector = new InterfaceCollector(new Class[0]);
        this.wrapper = wrapper;
        this.context = context;
    }

    public Object create(Instance instance) {
        Class[] interfaces = this.collector.collect(instance);
        FunctionResolver resolver = this.context.getResolver();
        TraceInterceptor interceptor = this.context.getInterceptor();
        ErrorHandler handler = this.context.getHandler();
        if (interfaces.length == 0) {
            throw new InternalStateException("No interfaces found for instance");
        }
        ScopeProxyHandler delegate = new ScopeProxyHandler(this.wrapper, resolver, instance);
        TraceProxyHandler tracer = new TraceProxyHandler(delegate, interceptor, handler, instance);
        return Proxy.newProxyInstance(this.loader, interfaces, (InvocationHandler)tracer);
    }

    public Object create(Function function, Class require) {
        Class[] interfaces = this.collector.collect(Delegate.class, require);
        FunctionResolver resolver = this.context.getResolver();
        if (interfaces.length == 0) {
            throw new InternalStateException("No interfaces found for function");
        }
        FunctionProxyHandler handler = new FunctionProxyHandler(this.wrapper, resolver, function);
        return Proxy.newProxyInstance(this.loader, interfaces, (InvocationHandler)handler);
    }
}

