/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert.proxy;

import java.lang.reflect.Method;
import org.snapscript.core.convert.proxy.ProxyArgumentExtractor;
import org.snapscript.core.convert.proxy.ProxyHandler;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;

public class ScopeProxyHandler
implements ProxyHandler {
    private final ProxyArgumentExtractor extractor;
    private final FunctionResolver resolver;
    private final ProxyWrapper wrapper;
    private final Scope scope;

    public ScopeProxyHandler(ProxyWrapper wrapper, FunctionResolver resolver, Scope scope) {
        this.extractor = new ProxyArgumentExtractor(wrapper);
        this.resolver = resolver;
        this.wrapper = wrapper;
        this.scope = scope;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object[] convert;
        String name = method.getName();
        FunctionCall call = this.resolver.resolveInstance(this.scope, this.scope, name, convert = this.extractor.extract(arguments));
        if (call == null) {
            throw new InternalStateException("Method '" + name + "' not found");
        }
        Object result = call.invoke(this.scope, this.scope, convert);
        if (result != null) {
            return this.wrapper.toProxy(result);
        }
        return null;
    }

    @Override
    public Scope extract() {
        return this.scope;
    }
}

