/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.snapscript.core.convert.proxy.ProxyHandler;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;

public class TraceProxyHandler
implements ProxyHandler {
    private final TraceInterceptor interceptor;
    private final InvocationHandler delegate;
    private final ErrorHandler handler;
    private final Scope scope;

    public TraceProxyHandler(InvocationHandler delegate, TraceInterceptor interceptor, ErrorHandler handler, Scope scope) {
        this.interceptor = interceptor;
        this.delegate = delegate;
        this.handler = handler;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] list) throws Throwable {
        Module module = this.scope.getModule();
        Path path = module.getPath();
        Trace trace = Trace.getNative(module, path);
        try {
            this.interceptor.traceBefore(this.scope, trace);
            Object object = this.delegate.invoke(proxy, method, list);
            return object;
        }
        catch (Exception cause) {
            Result result = this.handler.handleInternalError(Reason.THROW, this.scope, cause);
            return result;
        }
        finally {
            this.interceptor.traceAfter(this.scope, trace);
        }
    }

    @Override
    public Scope extract() {
        return this.scope;
    }
}

