/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.error;

import org.snapscript.core.error.CompileErrorFormatter;
import org.snapscript.core.error.InternalErrorBuilder;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class CompileErrorHandler {
    private final CompileErrorFormatter formatter;
    private final InternalErrorBuilder builder;

    public CompileErrorHandler(TypeExtractor extractor, ThreadStack stack) {
        this(extractor, stack, true);
    }

    public CompileErrorHandler(TypeExtractor extractor, ThreadStack stack, boolean replace) {
        this.builder = new InternalErrorBuilder(stack, replace);
        this.formatter = new CompileErrorFormatter(extractor);
    }

    public Result handleAccessError(Scope scope, String name) {
        String message = this.formatter.formatAccessError(name);
        throw this.builder.createInternalException(message);
    }

    public Result handleAccessError(Scope scope, Type type, String name) {
        String message = this.formatter.formatAccessError(type, name);
        throw this.builder.createInternalException(message);
    }

    public Result handleAccessError(Scope scope, String name, Type[] list) {
        String message = this.formatter.formatAccessError(name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleAccessError(Scope scope, Type type, String name, Type[] list) {
        String message = this.formatter.formatAccessError(type, name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleGenericError(Scope scope, String name, Type[] list) {
        String message = this.formatter.formatGenericError(name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleGenericError(Scope scope, Type type, String name, Type[] list) {
        String message = this.formatter.formatGenericError(type, name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleReferenceError(Scope scope, String name) {
        String message = this.formatter.formatReferenceError(name);
        throw this.builder.createInternalException(message);
    }

    public Result handleReferenceError(Scope scope, Type type, String name) {
        String message = this.formatter.formatReferenceError(type, name);
        throw this.builder.createInternalException(message);
    }

    public Result handleInvokeError(Scope scope, String name, Type[] list) {
        String message = this.formatter.formatInvokeError(name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleInvokeError(Scope scope, Type type, String name, Type[] list) {
        String message = this.formatter.formatInvokeError(type, name, list);
        throw this.builder.createInternalException(message);
    }

    public Result handleCastError(Scope scope, Type require, Type actual) {
        String message = this.formatter.formatCastError(require, actual);
        throw this.builder.createInternalException(message);
    }

    public Result handleConstructionError(Scope scope, Type type) {
        String message = this.formatter.formatConstructionError(type);
        throw this.builder.createInternalException(message);
    }
}

