/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.error;

import org.snapscript.core.error.ErrorMessageFormatter;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class RuntimeErrorFormatter {
    private final ErrorMessageFormatter formatter;
    private final TypeExtractor extractor;

    public RuntimeErrorFormatter(TypeExtractor extractor) {
        this.formatter = new ErrorMessageFormatter(extractor);
        this.extractor = extractor;
    }

    public String formatReferenceError(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Variable '");
        builder.append(name);
        builder.append("' not found in scope");
        return builder.toString();
    }

    public String formatReferenceError(Object object, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Property '");
        builder.append(name);
        builder.append("' not found");
        if (object != null) {
            Type type = this.extractor.getType(object);
            builder.append(" for '");
            builder.append(type);
            builder.append("'");
        }
        return builder.toString();
    }

    public String formatInvokeError(String name, Object[] list) {
        StringBuilder builder = new StringBuilder();
        if (name.equals("new")) {
            builder.append("Constructor '");
        } else {
            builder.append("Function '");
        }
        String signature = this.formatter.formatFunction(name, list);
        builder.append(signature);
        builder.append("' not found in scope");
        return builder.toString();
    }

    public String formatInvokeError(Object object, String name, Object[] list) {
        StringBuilder builder = new StringBuilder();
        if (name.equals("new")) {
            builder.append("Constructor '");
        } else {
            builder.append("Function '");
        }
        String signature = this.formatter.formatFunction(name, list);
        builder.append(signature);
        builder.append("' not found");
        if (object != null) {
            Type type = this.extractor.getType(object);
            builder.append(" for '");
            builder.append(type);
            builder.append("'");
        }
        return builder.toString();
    }

    public String formatInvokeError(Type type, String name, Object[] list) {
        StringBuilder builder = new StringBuilder();
        if (name.equals("new")) {
            builder.append("Constructor '");
        } else {
            builder.append("Function '");
        }
        String signature = this.formatter.formatFunction(name, list);
        builder.append(signature);
        builder.append("' not found for '");
        builder.append(type);
        builder.append("'");
        return builder.toString();
    }
}

