/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.List;
import java.util.Set;
import org.snapscript.core.EntityCache;
import org.snapscript.core.ModifierType;
import org.snapscript.core.convert.FunctionComparator;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.EmptyFunction;
import org.snapscript.core.function.ErrorSignature;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.type.TypeLoader;

public class ClosureFunctionFinder {
    private final EntityCache<Function> functions = new EntityCache();
    private final FunctionComparator comparator;
    private final TypeExtractor extractor;
    private final TypeLoader loader;
    private final Signature signature = new ErrorSignature();
    private final Function invalid = new EmptyFunction(this.signature);

    public ClosureFunctionFinder(FunctionComparator comparator, TypeExtractor extractor, TypeLoader loader) {
        this.comparator = comparator;
        this.extractor = extractor;
        this.loader = loader;
    }

    public Function findFunctional(Object actual) throws Exception {
        if (actual != null) {
            Class<?> type = actual.getClass();
            if (type == Class.class) {
                return this.findFunctional((Class)actual);
            }
            return this.findFunctional((Type)actual);
        }
        return null;
    }

    public Function findFunctional(Class actual) throws Exception {
        Type type;
        if (actual.isInterface() && (type = this.loader.loadType(actual)) != null) {
            return this.findFunctional(type);
        }
        return null;
    }

    public Function findFunctional(Type type) throws Exception {
        Function function = this.findMatch(type);
        Signature signature = function.getSignature();
        Origin origin = signature.getOrigin();
        if (!origin.isError()) {
            return function;
        }
        return null;
    }

    private Function findMatch(Type type) throws Exception {
        Function function = this.functions.fetch(type);
        if (function == null) {
            Function match = this.resolveBest(type);
            if (match != null) {
                this.functions.cache(type, match);
            } else {
                this.functions.cache(type, this.invalid);
            }
            return match;
        }
        return function;
    }

    private Function resolveBest(Type type) throws Exception {
        List<Function> functions;
        int modifiers = type.getModifiers();
        if (ModifierType.isFunction(modifiers) && !(functions = type.getFunctions()).isEmpty()) {
            return functions.get(0);
        }
        return this.resolveSingle(type);
    }

    private Function resolveSingle(Type type) throws Exception {
        Set<Type> types = this.extractor.getTypes(type);
        Scope scope = type.getScope();
        Function function = this.invalid;
        for (Type base : types) {
            Score score;
            Function match = this.resolveSingleAbstract(base);
            if (match == null) continue;
            if (function != this.invalid && (score = this.comparator.compare(scope, match, function)).isExact()) {
                return null;
            }
            function = match;
        }
        return function;
    }

    private Function resolveSingleAbstract(Type type) throws Exception {
        List<Function> functions = type.getFunctions();
        Function match = null;
        int count = 0;
        for (Function function : functions) {
            int modifiers = function.getModifiers();
            if (!ModifierType.isAbstract(modifiers) || !this.isValid(function)) continue;
            match = function;
            ++count;
        }
        if (count > 1) {
            return this.invalid;
        }
        if (count == 1) {
            return match;
        }
        return null;
    }

    private boolean isValid(Function function) throws Exception {
        String name = function.getName();
        Signature signature = function.getSignature();
        List<Parameter> parameters = signature.getParameters();
        int width = parameters.size();
        if (name.equals("hashCode")) {
            return width != 0;
        }
        if (name.equals("equals")) {
            return width != 1;
        }
        if (name.equals("toString")) {
            return width != 0;
        }
        return true;
    }
}

