/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.lang.reflect.Member;
import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.FunctionType;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.SignatureDescription;
import org.snapscript.core.function.SignatureMatcher;
import org.snapscript.core.module.Module;
import org.snapscript.core.type.Type;

public class FunctionSignature
implements Signature {
    private final List<Parameter> parameters;
    private final List<Constraint> constraints;
    private final SignatureDescription description;
    private final SignatureMatcher matcher;
    private final Type definition;
    private final Member source;
    private final Origin origin;
    private final boolean absolute;
    private final boolean variable;

    public FunctionSignature(List<Parameter> parameters, List<Constraint> constraints, Module module, Member source, Origin origin, boolean absolute) {
        this(parameters, constraints, module, source, origin, absolute, false);
    }

    public FunctionSignature(List<Parameter> parameters, List<Constraint> constraints, Module module, Member source, Origin origin, boolean absolute, boolean variable) {
        this.description = new SignatureDescription(this, module);
        this.matcher = new SignatureMatcher(this, module);
        this.definition = new FunctionType(this, module);
        this.constraints = constraints;
        this.parameters = parameters;
        this.absolute = absolute;
        this.variable = variable;
        this.source = source;
        this.origin = origin;
    }

    @Override
    public ArgumentConverter getConverter() {
        return this.matcher.getConverter();
    }

    @Override
    public List<Constraint> getGenerics() {
        return this.constraints;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Type getDefinition() {
        return this.definition;
    }

    @Override
    public Member getSource() {
        return this.source;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isVariable() {
        return this.variable;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    public String toString() {
        return this.description.toString();
    }
}

