/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.Collections;
import java.util.List;
import org.snapscript.common.CompleteProgress;
import org.snapscript.common.Progress;
import org.snapscript.core.ModifierType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.EmptyFunction;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.core.module.Module;
import org.snapscript.core.property.Property;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.StaticScope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeDescription;

public class FunctionType
implements Type {
    private final TypeDescription description;
    private final Progress<Phase> progress;
    private final Function function;
    private final Module module;
    private final Scope scope;
    private final String name;

    public FunctionType(Signature signature, Module module) {
        this(signature, module, "anonymous");
    }

    public FunctionType(Signature signature, Module module, String name) {
        this.function = new EmptyFunction(signature, "anonymous");
        this.progress = new CompleteProgress<Phase>();
        this.description = new TypeDescription(this);
        this.scope = new StaticScope(this);
        this.module = module;
        this.name = name;
    }

    @Override
    public Progress<Phase> getProgress() {
        return this.progress;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public List<Constraint> getGenerics() {
        return Collections.emptyList();
    }

    @Override
    public List<Property> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public List<Function> getFunctions() {
        return Collections.singletonList(this.function);
    }

    @Override
    public List<Constraint> getTypes() {
        return Collections.emptyList();
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Class getType() {
        return null;
    }

    @Override
    public Type getOuter() {
        return null;
    }

    @Override
    public Type getEntry() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return ModifierType.FUNCTION.mask;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String toString() {
        return this.description.toString();
    }
}

