/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.bind.FunctionMatcher;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.variable.Value;

public class InvocationCache {
    private final TypeExtractor extractor;
    private final FunctionMatcher matcher;
    private final AtomicInteger counter = new AtomicInteger();
    private final Connection[] cache = new Connection[3];
    private final Object[] keys = new Object[3];

    public InvocationCache(FunctionMatcher matcher, TypeExtractor extractor) {
        this.extractor = extractor;
        this.matcher = matcher;
    }

    public Invocation<?> fetch(Scope scope, Object[] array) throws Exception {
        Type type = scope.getType();
        int count = this.counter.get();
        for (int i = 0; i < count; ++i) {
            if (i >= this.cache.length) continue;
            Connection connection = this.cache[i];
            Object key = this.keys[i];
            if (connection == null || key != type || !this.cache[i].match(scope, Value.NULL, array)) continue;
            return this.cache[i];
        }
        return this.fetch(scope, Value.NULL, array, type);
    }

    public Invocation<?> fetch(Scope scope, Value value, Object[] array) throws Exception {
        Object object = value.getValue();
        Type type = this.extractor.getType(object);
        int count = this.counter.get();
        for (int i = 0; i < count; ++i) {
            if (i >= this.cache.length) continue;
            Connection connection = this.cache[i];
            Object key = this.keys[i];
            if (connection == null || key != type || !this.cache[i].match(scope, value, array)) continue;
            return this.cache[i];
        }
        return this.fetch(scope, value, array, type);
    }

    private Invocation<?> fetch(Scope scope, Value value, Object[] array, Type type) throws Exception {
        int next;
        FunctionDispatcher dispatcher = this.matcher.match(scope, value);
        Connection connection = dispatcher.connect(scope, value, array);
        int count = this.counter.get();
        if (connection != null && count < this.cache.length && connection.match(scope, value, array) && (next = this.counter.getAndIncrement()) < this.cache.length) {
            this.cache[next] = connection;
            this.keys[next] = type;
            count = next;
        }
        return connection;
    }
}

