/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.FunctionProxy;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.FunctionDescription;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.Signature;
import org.snapscript.core.type.Type;

public class InvocationFunction
implements Function {
    private final FunctionDescription description;
    private final List<Annotation> annotations;
    private final Invocation invocation;
    private final Constraint constraint;
    private final FunctionProxy proxy;
    private final Signature signature;
    private final Type source;
    private final String name;
    private final int modifiers;

    public InvocationFunction(Signature signature, Invocation invocation, Type source, Constraint constraint, String name) {
        this(signature, invocation, source, constraint, name, 0);
    }

    public InvocationFunction(Signature signature, Invocation invocation, Type source, Constraint constraint, String name, int modifiers) {
        this(signature, invocation, source, constraint, name, modifiers, 0);
    }

    public InvocationFunction(Signature signature, Invocation invocation, Type source, Constraint constraint, String name, int modifiers, int start) {
        this.description = new FunctionDescription(signature, source, name, start);
        this.annotations = new ArrayList<Annotation>();
        this.proxy = new FunctionProxy(this);
        this.constraint = constraint;
        this.invocation = invocation;
        this.signature = signature;
        this.modifiers = modifiers;
        this.source = source;
        this.name = name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers | ModifierType.FUNCTION.mask;
    }

    @Override
    public Type getSource() {
        return this.source;
    }

    @Override
    public Type getHandle() {
        return this.signature.getDefinition();
    }

    @Override
    public Object getProxy(Class type) {
        return this.proxy.getProxy(type);
    }

    @Override
    public Object getProxy() {
        return this.proxy.getProxy();
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public List<Constraint> getGenerics() {
        return this.signature.getGenerics();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public String getDescription() {
        return this.description.getDescription();
    }

    @Override
    public String toString() {
        return this.description.toString();
    }
}

