/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Accessor;
import org.snapscript.core.function.ScopeAccessor;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.variable.Value;

public class ModuleAccessor
implements Accessor {
    private final Accessor accessor;
    private final Statement body;
    private final Module module;
    private final Scope scope;
    private final String name;

    public ModuleAccessor(Module module, Statement body, Scope scope, String name) {
        this.accessor = new ScopeAccessor(name);
        this.module = module;
        this.scope = scope;
        this.name = name;
        this.body = body;
    }

    public Object getValue(Object source) {
        try {
            State state = this.scope.getState();
            Value field = state.getValue(this.name);
            if (field == null) {
                Execution execution = this.body.compile(this.scope, null);
                execution.execute(this.scope);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Reference to '" + this.name + "' in '" + this.module + "' failed", e);
        }
        return this.accessor.getValue(this.scope);
    }

    public void setValue(Object source, Object value) {
        try {
            State state = this.scope.getState();
            Value field = state.getValue(this.name);
            if (field == null) {
                Execution execution = this.body.compile(this.scope, null);
                execution.execute(this.scope);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Reference to '" + this.name + "' in '" + this.module + "' failed", e);
        }
        this.accessor.setValue(this.scope, value);
    }
}

