/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.lang.reflect.Array;
import java.util.List;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;

public class SignatureAligner {
    private final Signature signature;

    public SignatureAligner(Signature signature) {
        this.signature = signature;
    }

    public Object[] align(Object ... list) throws Exception {
        List<Parameter> parameters;
        int require;
        int start;
        int actual;
        int remaining;
        if (this.signature.isVariable() && (remaining = (actual = list.length) - (start = (require = (parameters = this.signature.getParameters()).size()) - 1)) >= 0) {
            Object[] array = new Object[remaining];
            for (int i = 0; i < remaining; ++i) {
                try {
                    Array.set(array, i, list[i + start]);
                    continue;
                }
                catch (Exception e) {
                    throw new InternalStateException("Invalid argument at " + i + " for" + this.signature, e);
                }
            }
            Object[] copy = new Object[require];
            if (require > list.length) {
                System.arraycopy(list, 0, copy, 0, list.length);
            } else {
                System.arraycopy(list, 0, copy, 0, require);
            }
            copy[start] = array;
            return copy;
        }
        return list;
    }
}

