/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.List;
import org.snapscript.core.Entity;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class SignatureDescription {
    private final Signature signature;
    private final Entity entity;
    private final int start;

    public SignatureDescription(Signature signature, Entity entity) {
        this(signature, entity, 0);
    }

    public SignatureDescription(Signature signature, Entity entity, int start) {
        this.signature = signature;
        this.entity = entity;
        this.start = start;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.signature != null) {
            List<Parameter> parameters = this.signature.getParameters();
            Scope scope = this.entity.getScope();
            int size = parameters.size();
            for (int i = this.start; i < size; ++i) {
                Parameter parameter = parameters.get(i);
                Constraint constraint = parameter.getConstraint();
                Type type = constraint.getType(scope);
                String name = parameter.getName();
                if (i > this.start) {
                    builder.append(", ");
                }
                builder.append(name);
                if (parameter.isVariable()) {
                    builder.append("...");
                }
                if (type == null) continue;
                String qualifier = type.getName();
                builder.append(": ");
                builder.append(qualifier);
            }
        }
        builder.append(")");
        return builder.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

