/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Accessor;
import org.snapscript.core.function.ScopeAccessor;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.variable.Value;

public class StaticAccessor
implements Accessor {
    private final Accessor accessor;
    private final TypeBody body;
    private final String name;
    private final Type type;

    public StaticAccessor(TypeBody body, Type type, String name) {
        this.accessor = new ScopeAccessor(name);
        this.body = body;
        this.name = name;
        this.type = type;
    }

    public Object getValue(Object source) {
        Scope scope = this.type.getScope();
        State state = scope.getState();
        Value field = state.getValue(this.name);
        try {
            if (field == null) {
                this.body.allocate(scope, this.type);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Static reference to '" + this.name + "' in '" + this.type + "' failed", e);
        }
        return this.accessor.getValue(scope);
    }

    public void setValue(Object source, Object value) {
        Scope scope = this.type.getScope();
        State state = scope.getState();
        Value field = state.getValue(this.name);
        try {
            if (field == null) {
                this.body.allocate(scope, this.type);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Static reference to '" + this.name + "' in '" + this.type + "' failed", e);
        }
        this.accessor.setValue(scope, value);
    }
}

