/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.bind;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.function.bind.FunctionMatcher;
import org.snapscript.core.function.resolve.FunctionResolver;

public class FunctionBinder {
    private final Cache<String, FunctionMatcher> cache = new CopyOnWriteCache<String, FunctionMatcher>();
    private final FunctionResolver resolver;
    private final ErrorHandler handler;

    public FunctionBinder(FunctionResolver resolver, ErrorHandler handler) {
        this.handler = handler;
        this.resolver = resolver;
    }

    public FunctionMatcher bind(String name) {
        FunctionMatcher index = this.cache.fetch(name);
        if (index == null) {
            index = new FunctionMatcher(this.resolver, this.handler, name);
            this.cache.cache(name, index);
        }
        return index;
    }
}

