/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.bind;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.function.dispatch.EmptyDispatcher;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.dispatch.FunctionDispatcherBuilder;
import org.snapscript.core.function.dispatch.LocalDispatcher;
import org.snapscript.core.function.dispatch.TypeLocalDispatcher;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class FunctionMatcher {
    private final Cache<Class, FunctionDispatcher> cache;
    private final FunctionDispatcherBuilder builder;
    private final FunctionDispatcher instance;
    private final FunctionDispatcher local;
    private final FunctionDispatcher empty;

    public FunctionMatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.builder = new FunctionDispatcherBuilder(resolver, handler, name);
        this.cache = new CopyOnWriteCache<Class, FunctionDispatcher>();
        this.instance = new TypeLocalDispatcher(resolver, handler, name);
        this.local = new LocalDispatcher(resolver, handler, name);
        this.empty = new EmptyDispatcher();
    }

    public FunctionDispatcher match(Scope scope) throws Exception {
        Type type = scope.getType();
        if (type != null) {
            return this.instance;
        }
        return this.local;
    }

    public FunctionDispatcher match(Scope scope, Constraint left) throws Exception {
        Type type = left.getType(scope);
        if (type != null) {
            return this.builder.create(scope, left);
        }
        return this.empty;
    }

    public FunctionDispatcher match(Scope scope, Value left) throws Exception {
        Type type = scope.getType();
        Object object = left.getValue();
        if (object != null) {
            Class<?> key = object.getClass();
            FunctionDispatcher dispatcher = this.cache.fetch(key);
            if (dispatcher == null) {
                dispatcher = this.builder.create(scope, key);
                this.cache.cache(key, dispatcher);
            }
            return dispatcher;
        }
        if (type != null) {
            return this.instance;
        }
        return this.local;
    }
}

