/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import java.util.List;
import org.snapscript.core.array.ArrayBuilder;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class ArrayDispatcher
implements FunctionDispatcher {
    private final FunctionResolver resolver;
    private final ArrayBuilder builder = new ArrayBuilder();
    private final ErrorHandler handler;
    private final String name;

    public ArrayDispatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.resolver = resolver;
        this.handler = handler;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint constraint, Type ... arguments) throws Exception {
        Type actual = constraint.getType(scope);
        Type list = this.builder.convert(actual);
        FunctionCall call = this.resolver.resolveInstance(scope, list, this.name, arguments);
        if (call == null) {
            this.handler.handleCompileError(Reason.INVOKE, scope, actual, this.name, arguments);
        }
        return call.check(scope, constraint, arguments);
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... arguments) throws Exception {
        Object object = value.getValue();
        List list = this.builder.convert(object);
        FunctionCall call = this.resolver.resolveInstance(scope, list, this.name, arguments);
        if (call == null) {
            this.handler.handleRuntimeError(Reason.INVOKE, scope, object, this.name, arguments);
        }
        return new ArrayConnection(call, this.builder);
    }

    private static class ArrayConnection
    implements Connection<Value> {
        private final ArrayBuilder builder;
        private final FunctionCall call;

        public ArrayConnection(FunctionCall call, ArrayBuilder builder) {
            this.builder = builder;
            this.call = call;
        }

        @Override
        public Object invoke(Scope scope, Value value, Object ... arguments) throws Exception {
            Object source = value.getValue();
            List list = this.builder.convert(source);
            return this.call.invoke(scope, list, arguments);
        }

        @Override
        public boolean match(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.match(scope, object, arguments);
        }
    }
}

