/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.Delegate;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionConnection;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class DelegateDispatcher
implements FunctionDispatcher {
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final String name;

    public DelegateDispatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.resolver = resolver;
        this.handler = handler;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint constraint, Type ... arguments) throws Exception {
        Type object = constraint.getType(scope);
        FunctionCall call = this.resolver.resolveFunction(scope, object, this.name, arguments);
        if (call == null) {
            this.handler.handleCompileError(Reason.INVOKE, scope, object, this.name, arguments);
        }
        return call.check(scope, constraint, arguments);
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... arguments) throws Exception {
        Delegate object = (Delegate)value.getValue();
        FunctionCall call = this.resolver.resolveFunction(scope, object, this.name, arguments);
        if (call == null) {
            this.handler.handleRuntimeError(Reason.INVOKE, scope, object, this.name, arguments);
        }
        return new FunctionConnection(call);
    }
}

