/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import java.util.Map;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.Delegate;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.dispatch.ArrayDispatcher;
import org.snapscript.core.function.dispatch.ClosureDispatcher;
import org.snapscript.core.function.dispatch.DelegateDispatcher;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.dispatch.MapDispatcher;
import org.snapscript.core.function.dispatch.ModuleDispatcher;
import org.snapscript.core.function.dispatch.TypeInstanceDispatcher;
import org.snapscript.core.function.dispatch.TypeStaticDispatcher;
import org.snapscript.core.function.dispatch.ValueDispatcher;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class FunctionDispatcherBuilder {
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final String name;

    public FunctionDispatcherBuilder(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.handler = handler;
        this.resolver = resolver;
        this.name = name;
    }

    public FunctionDispatcher create(Scope scope, Class type) throws Exception {
        if (Module.class.isAssignableFrom(type)) {
            return new ModuleDispatcher(this.resolver, this.handler, this.name);
        }
        if (Type.class.isAssignableFrom(type)) {
            return new TypeStaticDispatcher(this.resolver, this.handler, this.name);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapDispatcher(this.resolver, this.handler, this.name);
        }
        if (Function.class.isAssignableFrom(type)) {
            return new ClosureDispatcher(this.resolver, this.handler, this.name);
        }
        if (Delegate.class.isAssignableFrom(type)) {
            return new DelegateDispatcher(this.resolver, this.handler, this.name);
        }
        if (Value.class.isAssignableFrom(type)) {
            return new ValueDispatcher(this.resolver, this.handler, this.name);
        }
        if (type.isArray()) {
            return new ArrayDispatcher(this.resolver, this.handler, this.name);
        }
        return new TypeInstanceDispatcher(this.resolver, this.handler, this.name);
    }

    public FunctionDispatcher create(Scope scope, Constraint left) throws Exception {
        Type type = left.getType(scope);
        Class real = type.getType();
        int modifiers = type.getModifiers();
        if (left.isModule()) {
            return new ModuleDispatcher(this.resolver, this.handler, this.name);
        }
        if (left.isClass()) {
            return new TypeStaticDispatcher(this.resolver, this.handler, this.name);
        }
        if (ModifierType.isFunction(modifiers)) {
            return new ClosureDispatcher(this.resolver, this.handler, this.name);
        }
        if (ModifierType.isProxy(modifiers)) {
            return new DelegateDispatcher(this.resolver, this.handler, this.name);
        }
        if (ModifierType.isArray(modifiers)) {
            return new ArrayDispatcher(this.resolver, this.handler, this.name);
        }
        if (real != null && Map.class.isAssignableFrom(real)) {
            return new MapDispatcher(this.resolver, this.handler, this.name);
        }
        return new TypeInstanceDispatcher(this.resolver, this.handler, this.name);
    }
}

