/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionConnection;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class LocalDispatcher
implements FunctionDispatcher {
    private final FunctionResolver binder;
    private final ErrorHandler handler;
    private final String name;

    public LocalDispatcher(FunctionResolver binder, ErrorHandler handler, String name) {
        this.handler = handler;
        this.binder = binder;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint constraint, Type ... arguments) throws Exception {
        Type object = constraint.getType(scope);
        FunctionCall call = this.bind(scope, object, arguments);
        if (call == null) {
            this.handler.handleCompileError(Reason.INVOKE, scope, this.name, arguments);
        }
        return call.check(scope, constraint, arguments);
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... arguments) throws Exception {
        Object object = value.getValue();
        FunctionCall call = this.bind(scope, object, arguments);
        if (call == null) {
            this.handler.handleRuntimeError(Reason.INVOKE, scope, this.name, arguments);
        }
        return new FunctionConnection(call);
    }

    private FunctionCall bind(Scope scope, Object object, Object ... arguments) throws Exception {
        FunctionCall closure;
        Module module = scope.getModule();
        FunctionCall local = this.binder.resolveModule(scope, module, this.name, arguments);
        if (local == null && (closure = this.binder.resolveScope(scope, this.name, arguments)) != null) {
            return closure;
        }
        return local;
    }

    private FunctionCall bind(Scope scope, Type object, Type ... arguments) throws Exception {
        FunctionCall closure;
        Module module = scope.getModule();
        FunctionCall local = this.binder.resolveModule(scope, module, this.name, arguments);
        if (local == null && (closure = this.binder.resolveScope(scope, this.name, arguments)) != null) {
            return closure;
        }
        return local;
    }
}

