/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class TypeLocalDispatcher
implements FunctionDispatcher {
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final String name;

    public TypeLocalDispatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.resolver = resolver;
        this.handler = handler;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint constraint, Type ... arguments) throws Exception {
        Type object = constraint.getType(scope);
        FunctionCall match = this.bind(scope, object, arguments);
        if (match == null) {
            Type type = scope.getType();
            if (type != null) {
                this.handler.handleCompileError(Reason.INVOKE, scope, type, this.name, arguments);
            } else {
                this.handler.handleCompileError(Reason.INVOKE, scope, this.name, arguments);
            }
        }
        return match.check(scope, constraint, arguments);
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... arguments) throws Exception {
        Scope object = (Scope)value.getValue();
        Connection call = this.bind(scope, object, arguments);
        if (call == null) {
            Type type = scope.getType();
            if (type != null) {
                this.handler.handleRuntimeError(Reason.INVOKE, scope, type, this.name, arguments);
            } else {
                this.handler.handleRuntimeError(Reason.INVOKE, scope, this.name, arguments);
            }
        }
        return call;
    }

    private FunctionCall bind(Scope scope, Type object, Type ... arguments) throws Exception {
        Type type = scope.getType();
        FunctionCall local = this.resolver.resolveInstance(scope, type, this.name, arguments);
        if (local == null) {
            Module module = scope.getModule();
            FunctionCall external = this.resolver.resolveModule(scope, module, this.name, arguments);
            if (external != null) {
                return external;
            }
            FunctionCall closure = this.resolver.resolveScope(scope, this.name, arguments);
            if (closure != null) {
                return closure;
            }
        }
        return local;
    }

    private Connection bind(Scope scope, Scope object, Object ... arguments) throws Exception {
        FunctionCall local = this.resolver.resolveInstance(scope, scope, this.name, arguments);
        if (local == null) {
            Module module = scope.getModule();
            FunctionCall external = this.resolver.resolveModule(scope, module, this.name, arguments);
            if (external != null) {
                return new TypeLocalConnection(external, module);
            }
            FunctionCall closure = this.resolver.resolveScope(scope, this.name, arguments);
            if (closure != null) {
                return new TypeLocalConnection(closure, null);
            }
            return null;
        }
        return new TypeLocalConnection(local, null);
    }

    private static class TypeLocalConnection
    implements Connection {
        private final FunctionCall call;
        private final Module module;

        public TypeLocalConnection(FunctionCall call, Module module) {
            this.module = module;
            this.call = call;
        }

        @Override
        public boolean match(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.match(scope, object, arguments);
        }

        @Override
        public Object invoke(Scope scope, Object object, Object ... arguments) throws Exception {
            if (this.module != null) {
                return this.call.invoke(scope, this.module, arguments);
            }
            return this.call.invoke(scope, scope, arguments);
        }
    }
}

