/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionConnection;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class TypeStaticDispatcher
implements FunctionDispatcher {
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final String name;

    public TypeStaticDispatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.resolver = resolver;
        this.handler = handler;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint constraint, Type ... arguments) throws Exception {
        Type type = constraint.getType(scope);
        FunctionCall call = this.resolver.resolveStatic(scope, type, this.name, arguments);
        if (call == null) {
            this.handler.handleCompileError(Reason.INVOKE, scope, type, this.name, arguments);
        }
        return call.check(scope, constraint, arguments);
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... arguments) throws Exception {
        Type type = (Type)value.getValue();
        FunctionCall call = this.resolver.resolveStatic(scope, type, this.name, arguments);
        if (call == null) {
            FunctionCall instance = this.resolver.resolveInstance(scope, (Object)type, this.name, arguments);
            if (instance == null) {
                this.handler.handleRuntimeError(Reason.INVOKE, scope, type, this.name, arguments);
            }
            return new FunctionConnection(instance);
        }
        return new TypeStaticConnection(call);
    }

    private static class TypeStaticConnection
    implements Connection {
        private final FunctionCall call;

        public TypeStaticConnection(FunctionCall call) {
            this.call = call;
        }

        @Override
        public boolean match(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.match(scope, object, arguments);
        }

        @Override
        public Object invoke(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.invoke(scope, (Object)null, arguments);
        }
    }
}

