/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.dispatch;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.Connection;
import org.snapscript.core.function.dispatch.FunctionDispatcher;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class ValueDispatcher
implements FunctionDispatcher {
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final String name;

    public ValueDispatcher(FunctionResolver resolver, ErrorHandler handler, String name) {
        this.resolver = resolver;
        this.handler = handler;
        this.name = name;
    }

    @Override
    public Constraint compile(Scope scope, Constraint value, Type ... list) throws Exception {
        return Constraint.NONE;
    }

    @Override
    public Connection connect(Scope scope, Value value, Object ... list) throws Exception {
        Value reference = (Value)value.getValue();
        FunctionCall call = this.resolver.resolveValue(reference, list);
        if (call == null) {
            this.handler.handleRuntimeError(Reason.INVOKE, scope, this.name, list);
        }
        return new ValueConnection(call);
    }

    private static class ValueConnection
    implements Connection {
        private final FunctionCall call;

        public ValueConnection(FunctionCall call) {
            this.call = call;
        }

        @Override
        public boolean match(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.match(scope, object, arguments);
        }

        @Override
        public Object invoke(Scope scope, Object object, Object ... arguments) throws Exception {
            return this.call.invoke(scope, (Object)null, arguments);
        }
    }
}

