/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.List;
import org.snapscript.core.EntityCache;
import org.snapscript.core.convert.TypeInspector;
import org.snapscript.core.convert.proxy.Delegate;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.index.FunctionIndex;
import org.snapscript.core.function.index.FunctionIndexBuilder;
import org.snapscript.core.function.index.FunctionPathFinder;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.FunctionPointerConverter;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class DelegateIndexer {
    private final EntityCache<FunctionIndex> indexes;
    private final FunctionPointerConverter converter;
    private final FunctionIndexBuilder builder;
    private final FunctionPathFinder finder;
    private final TypeInspector inspector;
    private final TypeExtractor extractor;

    public DelegateIndexer(TypeExtractor extractor, ThreadStack stack) {
        this.builder = new FunctionIndexBuilder(extractor, stack);
        this.converter = new FunctionPointerConverter(stack);
        this.indexes = new EntityCache();
        this.finder = new FunctionPathFinder();
        this.inspector = new TypeInspector();
        this.extractor = extractor;
    }

    public FunctionPointer match(Type type, String name, Type ... values) throws Exception {
        FunctionIndex match = this.indexes.fetch(type);
        if (match == null) {
            List<Type> path = this.finder.findPath(type);
            FunctionIndex table = this.builder.create(type);
            int size = path.size();
            for (int i = size - 1; i >= 0; --i) {
                Type entry = path.get(i);
                if (this.inspector.isProxy(entry)) continue;
                List<Function> functions = entry.getFunctions();
                for (Function function : functions) {
                    if (this.inspector.isSuperConstructor(type, function)) continue;
                    FunctionPointer pointer = this.converter.convert(function);
                    table.index(pointer);
                }
            }
            this.indexes.cache(type, table);
            return table.resolve(name, values);
        }
        return match.resolve(name, values);
    }

    public FunctionPointer match(Delegate value, String name, Object ... values) throws Exception {
        Type type = this.extractor.getType(value);
        FunctionIndex match = this.indexes.fetch(type);
        if (match == null) {
            List<Type> path = this.finder.findPath(type);
            FunctionIndex table = this.builder.create(type);
            int size = path.size();
            for (int i = size - 1; i >= 0; --i) {
                Type entry = path.get(i);
                if (this.inspector.isProxy(entry)) continue;
                List<Function> functions = entry.getFunctions();
                for (Function function : functions) {
                    if (this.inspector.isSuperConstructor(type, function)) continue;
                    FunctionPointer pointer = this.converter.convert(function);
                    table.index(pointer);
                }
            }
            this.indexes.cache(type, table);
            return table.resolve(name, values);
        }
        return match.resolve(name, values);
    }
}

