/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.index.FunctionIndexPartition;
import org.snapscript.core.function.index.FunctionKeyBuilder;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.FunctionReducer;
import org.snapscript.core.type.Type;

public class FunctionIndex {
    private FunctionIndexPartition[] partitions;
    private FunctionIndexPartition variable;
    private FunctionKeyBuilder builder;
    private FunctionReducer reducer;
    private int limit;

    public FunctionIndex(FunctionReducer reducer, FunctionKeyBuilder builder) {
        this(reducer, builder, 20);
    }

    public FunctionIndex(FunctionReducer reducer, FunctionKeyBuilder builder, int limit) {
        this.variable = new FunctionIndexPartition(reducer, builder);
        this.partitions = new FunctionIndexPartition[2];
        this.reducer = reducer;
        this.builder = builder;
        this.limit = limit;
    }

    public List<FunctionPointer> resolve(int modifiers) {
        ArrayList<FunctionPointer> matches = new ArrayList<FunctionPointer>();
        for (FunctionIndexPartition partition : this.partitions) {
            List<FunctionPointer> group;
            if (partition == null || (group = partition.resolve(modifiers)) == null) continue;
            matches.addAll(group);
        }
        return matches;
    }

    public FunctionPointer resolve(String name, Type ... arguments) throws Exception {
        FunctionIndexPartition partition;
        int size = arguments.length;
        if (size < this.partitions.length && (partition = this.partitions[size]) != null) {
            return partition.resolve(name, arguments);
        }
        return this.variable.resolve(name, arguments);
    }

    public FunctionPointer resolve(String name, Object ... arguments) throws Exception {
        FunctionIndexPartition partition;
        int size = arguments.length;
        if (size < this.partitions.length && (partition = this.partitions[size]) != null) {
            return partition.resolve(name, arguments);
        }
        return this.variable.resolve(name, arguments);
    }

    public void index(FunctionPointer pointer) throws Exception {
        Function function = pointer.getFunction();
        Signature signature = function.getSignature();
        List<Parameter> parameters = signature.getParameters();
        int size = parameters.size();
        if (signature.isVariable()) {
            int maximum = size + this.limit;
            int minimum = size - 1;
            for (int i = maximum; i >= minimum; --i) {
                this.index(pointer, i);
            }
        } else {
            this.index(pointer, size);
        }
    }

    private void index(FunctionPointer pointer, int size) throws Exception {
        FunctionIndexPartition cache;
        Function function = pointer.getFunction();
        Signature signature = function.getSignature();
        if (size >= this.partitions.length) {
            FunctionIndexPartition[] copy = new FunctionIndexPartition[size + 1];
            for (int i = 0; i < this.partitions.length; ++i) {
                copy[i] = this.partitions[i];
            }
            this.partitions = copy;
        }
        if ((cache = this.partitions[size]) == null) {
            cache = this.partitions[size] = new FunctionIndexPartition(this.reducer, this.builder);
        }
        if (signature.isVariable()) {
            this.variable.index(pointer);
        }
        cache.index(pointer);
    }
}

