/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.index.FunctionKeyBuilder;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.FunctionPointerCollector;
import org.snapscript.core.function.index.FunctionReducer;
import org.snapscript.core.function.index.ParameterTypeExtractor;
import org.snapscript.core.type.Type;

public class FunctionIndexGroup {
    private final List<FunctionPointer> group;
    private final Cache<Object, FunctionPointer> cache = new CopyOnWriteCache<Object, FunctionPointer>();
    private final FunctionPointerCollector collector;
    private final ParameterTypeExtractor extractor;
    private final FunctionKeyBuilder builder;
    private final FunctionReducer searcher;
    private final AtomicBoolean types;
    private final String name;

    public FunctionIndexGroup(FunctionReducer searcher, FunctionKeyBuilder builder, String name) {
        this.group = new ArrayList<FunctionPointer>();
        this.collector = new FunctionPointerCollector(this.group);
        this.extractor = new ParameterTypeExtractor();
        this.types = new AtomicBoolean();
        this.searcher = searcher;
        this.builder = builder;
        this.name = name;
    }

    public FunctionPointer resolve(Type ... list) throws Exception {
        int count = this.group.size();
        if (this.types.get()) {
            Object key = this.builder.create(this.name, list);
            FunctionPointer pointer = this.cache.fetch(key);
            if (pointer == null) {
                FunctionPointer match = this.searcher.reduce(this.group, this.name, list);
                Function function = match.getFunction();
                Signature signature = function.getSignature();
                if (signature.isAbsolute()) {
                    this.cache.cache(key, match);
                }
                return this.validate(match);
            }
            return this.validate(pointer);
        }
        if (count > 0) {
            return this.group.get(count - 1);
        }
        return null;
    }

    public FunctionPointer resolve(Object ... list) throws Exception {
        int count = this.group.size();
        if (this.types.get()) {
            Object key = this.builder.create(this.name, list);
            FunctionPointer pointer = this.cache.fetch(key);
            if (pointer == null) {
                FunctionPointer match = this.searcher.reduce(this.group, this.name, list);
                Function function = match.getFunction();
                Signature signature = function.getSignature();
                if (signature.isAbsolute()) {
                    this.cache.cache(key, match);
                }
                return this.validate(match);
            }
            return this.validate(pointer);
        }
        if (count > 0) {
            return this.group.get(count - 1);
        }
        return null;
    }

    public void index(FunctionPointer pointer) throws Exception {
        Type[] list = this.extractor.extract(pointer);
        Object key = this.builder.create(this.name, list);
        int count = 0;
        for (int i = 0; i < list.length; ++i) {
            Type type = list[i];
            if (type == null) continue;
            ++count;
        }
        this.collector.collect(key, pointer);
        this.types.set(count > 0);
    }

    private FunctionPointer validate(FunctionPointer pointer) throws Exception {
        Function function = pointer.getFunction();
        Signature signature = function.getSignature();
        Origin origin = signature.getOrigin();
        if (!origin.isError()) {
            return pointer;
        }
        return null;
    }
}

