/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.index.FunctionIndexGroup;
import org.snapscript.core.function.index.FunctionKeyBuilder;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.FunctionReducer;
import org.snapscript.core.type.Type;

public class FunctionIndexPartition {
    private final Map<String, FunctionIndexGroup> groups = new HashMap<String, FunctionIndexGroup>();
    private final Set<FunctionPointer> pointers = new HashSet<FunctionPointer>();
    private final FunctionKeyBuilder builder;
    private final FunctionReducer matcher;

    public FunctionIndexPartition(FunctionReducer matcher, FunctionKeyBuilder builder) {
        this.matcher = matcher;
        this.builder = builder;
    }

    public FunctionPointer resolve(String name, Type ... list) throws Exception {
        FunctionIndexGroup group = this.groups.get(name);
        if (group != null) {
            return group.resolve(list);
        }
        return null;
    }

    public FunctionPointer resolve(String name, Object ... list) throws Exception {
        FunctionIndexGroup group = this.groups.get(name);
        if (group != null) {
            return group.resolve(list);
        }
        return null;
    }

    public List<FunctionPointer> resolve(int modifiers) {
        ArrayList<FunctionPointer> matches = new ArrayList<FunctionPointer>();
        for (FunctionPointer pointer : this.pointers) {
            Function function = pointer.getFunction();
            int mask = function.getModifiers();
            if ((modifiers & mask) != modifiers) continue;
            matches.add(pointer);
        }
        return matches;
    }

    public void index(FunctionPointer pointer) throws Exception {
        Function function = pointer.getFunction();
        String name = function.getName();
        FunctionIndexGroup group = this.groups.get(name);
        if (group == null) {
            group = new FunctionIndexGroup(this.matcher, this.builder, name);
            this.groups.put(name, group);
        }
        this.pointers.add(pointer);
        group.index(pointer);
    }
}

