/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.snapscript.common.Progress;
import org.snapscript.core.EntityCache;
import org.snapscript.core.constraint.AnyConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.TypeInspector;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.Type;

public class FunctionPathFinder {
    private final EntityCache<List<Type>> paths = new EntityCache();
    private final TypeInspector inspector = new TypeInspector();
    private final Constraint any = new AnyConstraint();
    private final long wait;

    public FunctionPathFinder() {
        this(60000L);
    }

    public FunctionPathFinder(long wait) {
        this.wait = wait;
    }

    public List<Type> findPath(Type type) {
        List<Type> path = this.paths.fetch(type);
        if (path == null) {
            ArrayList<Type> result = new ArrayList<Type>();
            this.findTypes(type, result);
            this.paths.cache(type, result);
            return result;
        }
        return path;
    }

    private void findTypes(Type type, List<Type> done) {
        Progress<Phase> progress = type.getProgress();
        Scope scope = type.getScope();
        Type base = this.any.getType(scope);
        Class real = type.getType();
        if (!progress.wait(Phase.DEFINE, this.wait)) {
            throw new InternalStateException("Type '" + type + "' has not been defined");
        }
        this.findClasses(type, done);
        if (real == null) {
            this.findTraits(type, done);
        }
        done.add(base);
    }

    private void findTraits(Type type, List<Type> done) {
        List<Constraint> types = type.getTypes();
        Iterator<Constraint> iterator = types.iterator();
        if (iterator.hasNext()) {
            Scope scope = type.getScope();
            Constraint next = iterator.next();
            while (iterator.hasNext()) {
                Constraint trait = iterator.next();
                Type match = trait.getType(scope);
                if (done.contains(match)) continue;
                done.add(match);
            }
            Type match = next.getType(scope);
            if (!done.contains(match)) {
                this.findTraits(match, done);
            }
        }
    }

    private void findClasses(Type type, List<Type> done) {
        List<Constraint> types = type.getTypes();
        Iterator<Constraint> iterator = types.iterator();
        Scope scope = type.getScope();
        if (!this.inspector.isProxy(type) && !this.inspector.isAny(type)) {
            done.add(type);
        }
        while (iterator.hasNext()) {
            Constraint next = iterator.next();
            Type match = next.getType(scope);
            if (done.contains(match)) continue;
            this.findClasses(match, done);
        }
    }
}

