/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.List;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.index.ErrorPointer;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;

public class FunctionReducer {
    private final FunctionPointer invalid = new ErrorPointer();

    public FunctionReducer(ThreadStack stack) {
    }

    public FunctionPointer reduce(List<FunctionPointer> pointers, String name, Type ... types) throws Exception {
        int size = pointers.size();
        if (size > 0) {
            FunctionPointer call = this.invalid;
            Score best = Score.INVALID;
            for (int i = size - 1; i >= 0; --i) {
                Signature signature;
                ArgumentConverter converter;
                Score score;
                FunctionPointer next = pointers.get(i);
                Function function = next.getFunction();
                String match = function.getName();
                if (!match.equals(name) || (score = (converter = (signature = function.getSignature()).getConverter()).score(types)).compareTo(best) <= 0) continue;
                call = next;
                best = score;
            }
            return call;
        }
        return this.invalid;
    }

    public FunctionPointer reduce(List<FunctionPointer> pointers, String name, Object ... values) throws Exception {
        int size = pointers.size();
        if (size > 0) {
            FunctionPointer call = this.invalid;
            Score best = Score.INVALID;
            for (int i = size - 1; i >= 0; --i) {
                Signature signature;
                ArgumentConverter converter;
                Score score;
                FunctionPointer next = pointers.get(i);
                Function function = next.getFunction();
                String match = function.getName();
                if (!match.equals(name) || (score = (converter = (signature = function.getSignature()).getConverter()).score(values)).compareTo(best) <= 0) continue;
                call = next;
                best = score;
            }
            return call;
        }
        return this.invalid;
    }
}

