/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.Retention;
import org.snapscript.core.function.index.ReturnType;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class LocalFunctionIndexer {
    private final FunctionIndexer indexer;

    public LocalFunctionIndexer(FunctionIndexer indexer) {
        this.indexer = indexer;
    }

    public FunctionPointer index(Scope scope, String name, Type ... types) throws Exception {
        Module module = scope.getModule();
        Type type = module.getType(name);
        if (type != null) {
            return this.resolve(type, name, types);
        }
        return null;
    }

    private FunctionPointer resolve(Type type, String name, Type ... types) throws Exception {
        Module module = type.getModule();
        Class real = type.getType();
        if (real == null) {
            Type[] array = new Type[types.length + 1];
            for (int i = 0; i < types.length; ++i) {
                array[i + 1] = types[i];
            }
            array[0] = module.getType(Type.class);
            types = array;
        }
        return this.indexer.index(type, "new", types);
    }

    public FunctionPointer index(Scope scope, String name, Object ... values) throws Exception {
        FunctionPointer pointer;
        Module module = scope.getModule();
        Type type = module.getType(name);
        if (type != null && (pointer = this.resolve(type, name, values)) != null) {
            return new ConstructorPointer(pointer, type);
        }
        return null;
    }

    private FunctionPointer resolve(Type type, String name, Object ... values) throws Exception {
        Class real = type.getType();
        if (real == null) {
            Object[] array = new Object[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                array[i + 1] = values[i];
            }
            array[0] = type;
            values = array;
        }
        return this.indexer.index(type, "new", values);
    }

    private static class ConstructorInvocation
    implements Invocation {
        private final FunctionPointer pointer;
        private final Type type;

        public ConstructorInvocation(FunctionPointer pointer, Type type) {
            this.pointer = pointer;
            this.type = type;
        }

        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            Invocation invocation = this.pointer.getInvocation();
            Class real = this.type.getType();
            if (real == null) {
                Object[] array = new Object[list.length + 1];
                for (int i = 0; i < list.length; ++i) {
                    array[i + 1] = list[i];
                }
                array[0] = this.type;
                list = array;
            }
            return invocation.invoke(scope, null, list);
        }
    }

    private static class ConstructorPointer
    implements FunctionPointer {
        private final ConstructorInvocation invocation;
        private final FunctionPointer pointer;

        public ConstructorPointer(FunctionPointer pointer, Type type) {
            this.invocation = new ConstructorInvocation(pointer, type);
            this.pointer = pointer;
        }

        @Override
        public ReturnType getType(Scope scope) {
            return this.pointer.getType(scope);
        }

        @Override
        public Function getFunction() {
            return this.pointer.getFunction();
        }

        @Override
        public Invocation getInvocation() {
            return this.invocation;
        }

        @Override
        public Retention getRetention() {
            return this.pointer.getRetention();
        }
    }
}

